import java.awt.Color;
import java.awt.Container;
import java.awt.Graphics;

import javax.swing.JFrame;
import javax.swing.JPanel;

@SuppressWarnings("serial")
public class Crossword extends JPanel
{
/** Each element is a Square object with a color (black or white) and a number. 
	 *  puzzle[r][c] represents the square in row r, column c.
	 *  There is at least one row in the puzzle.
	 */
	private Square[][] puzzle; /** Constructs a crossword puzzle grid.
    /** 
	 * Precondition: There is at least one row in blackSquares. 
	 * Postcondition:
	 * - The crossword puzzle grid has the same dimensions as blackSquares.
	 * - The Square object at row r, column c in the crossword puzzle grid is black 
	 *   if and only if blackSquares[r][c] is true
	 * - The squares in the puzzle are labeled according to the crossword labeling rule.
	 */
	public Crossword(boolean[][] blackSquares)
	{ /* to be implemented in part (b) */ 
		
	}
	/** Returns true if the square at row r, column c should be labeled with a positive number; 
	 * false otherwise.
	 * Precondition: r and c are valid indexes in blackSquares.
	 */
	private boolean toBeLabeled(int r, int c, boolean[][] blackSquares)
	{ /* to be implemented in part (a) */ 
		 
	}
	// There may be instance variables, constructors, and methods that are not shown.
	public void paintComponent(Graphics g)
    {
        setBackground(Color.WHITE);
        super.paintComponent(g);
        g.setColor(Color.BLACK);
        g.drawString("Crossword ", 20, 20);
        int width = this.getWidth() - SIZE;
        for( int r = 0; r < puzzle.length;  r++ )
        	for (int c =0; c < puzzle[0].length; c++)
        	{
        		Square s = puzzle[r][c];

        		int x= SIZE/2 + c*SIZE;
        		int y = SIZE/2 + r*SIZE;
        		
        		if (s.isBlack() ) {
        		g.fillRect(x, y, SIZE, SIZE);
        		} else
        		{
        			g.drawRect(x, y, SIZE, SIZE);
        		}
        		if (s.num() != 0)
        			g.drawString(s.num()+"" , x+GAP, y+5*GAP );	
        	}
        
    }
	public static final int SIZE = 50;
    public static final int WIDTH = 500;
    public static final int HEIGHT = 500;
    public static final int GAP =3;
    public static void main(String[] args) 
    {
    	
    	boolean [][] arr = {
    			{ true, false, false, true, true,  true,  false, false, false},
    			{false, false, false, false, true, false, false, false, false},
	            {false, false, false, false,false, false, true, true, true},
	            {false, false, true, false,false, false, true, false, false},
	            {true, true, true, false,false, false, false, false, false},
	            {false, false, false, false,true, false, false, false, false},
    			{false, false, false, true,true, true, false, false, true}
	            };
    	
    	JFrame window = new JFrame();
        window.setSize(WIDTH, HEIGHT);
        Container c = window.getContentPane();
        c.add(new Crossword(arr));

        window.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        window.setVisible(true);
        
    }
}